<?php
/**
 * Add Image Columns to Tables
 * This script ensures that the necessary image columns exist in the database
 */

require_once 'config.php';

$alterQueries = [
    // Add image column to services if it doesn't exist
    "ALTER TABLE `services` ADD COLUMN `image` VARCHAR(255) AFTER `status`",
    
    // Add image column to team_members if it doesn't exist
    "ALTER TABLE `team_members` ADD COLUMN `image` VARCHAR(255) AFTER `email`",
    
    // Add featured_image column to blog_posts if it doesn't exist
    "ALTER TABLE `blog_posts` ADD COLUMN `featured_image` VARCHAR(255) AFTER `category`"
];

foreach ($alterQueries as $query) {
    if ($conn->query($query) === TRUE) {
        echo "Column added or already exists: " . htmlspecialchars($query) . "<br>";
    } else {
        // Check if error is because column already exists
        if (strpos($conn->error, 'Duplicate column') !== false || strpos($conn->error, 'already exists') !== false) {
            echo "✓ Column already exists (no action needed)<br>";
        } else {
            echo "Error (may be non-critical): " . htmlspecialchars($conn->error) . "<br>";
        }
    }
}

echo "<br><strong>✓ Image columns check completed!</strong><br>";
echo "<a href='admin-dashboard.php'>Go to Admin Dashboard</a>";

$conn->close();
?>
